<?php

function wp_pinterest_to_wp_opt_selected($src,$val){
	if($src == $val) echo ' selected = "selected" ';
}


function wp_pinterest_to_wp_opt_checked($src,$val){
	if($src == $val) return ' checked = "checked" ';
}


//adding metabox to gallery items
add_action( 'admin_menu', 'wp_pinterest_to_wp_create_meta_box' );

function wp_pinterest_to_wp_create_meta_box(){
	add_meta_box( 'wp_pinterest_to_wp_page-meta-boxes', 'Gallery options', 'wp_pinterest_to_wp_page_meta_boxes', 'wp_pinterest_to_wp', 'normal', 'high' );
}

function wp_pinterest_to_wp_page_meta_boxes(){
	
	wp_pinterest_to_wp_page_meta_boxes_pin();
}

//metabox content 
function wp_pinterest_to_wp_page_meta_boxes_pin(){
	
	//reading meta values
	global $post;
	$id= $post->ID;
	$gallery_user=get_post_meta($id,'gallery_user',1);
	$gallery_type=get_post_meta($id,'gallery_type',1);
	
	if(trim($gallery_user) == ''){
		//new gallery
		$gallery_max=25;
		$gallery_padding=10;
		$gallery_bg=10;
		$gallery_width=150;
		$gallery_itm_width=150;
		$gallery_itm_height=160;
		$gallery_color=333333;
		$wp_pinterest_to_wp_ops=array('OPT_DESC_POP','OPT_LINK_POP','');
		
		$gallery_boards=get_option($gallery_user.'_boards',array());
		$gallery_board=get_post_meta($id,'gallery_board',1);
		
	}else{
		//old gallery
		
		$gallery_max=get_post_meta($id,'gallery_max',1);
		$gallery_padding=get_post_meta($id,'gallery_padding',1);
		$gallery_bg=get_post_meta($id,'gallery_bg',1);
		$gallery_width=get_post_meta($id,'gallery_width',1);
		$gallery_itm_width=get_post_meta($id,'gallery_itm_width',1);
		$gallery_itm_height=get_post_meta($id,'gallery_itm_height',1);
		$gallery_color=get_post_meta($id,'gallery_color',1);
		$wp_pinterest_to_wp_ops=get_post_meta($id,'wp_pinterest_to_wp_ops',1);
		$gallery_color=get_post_meta($id,'gallery_color',1);
		$gallery_boards=get_option($gallery_user.'_boards',array());
		$gallery_board=get_post_meta($id,'gallery_board',1);
		
	}
	
	
	
	if(! is_array($wp_pinterest_to_wp_ops))$wp_pinterest_to_wp_ops=array();
 
	
	?>

	<div class="wp_attachment_details TTWForm">

			<div id="gallery_user-container" class="field f_100">
               <label for="gallery_user">
                    Pinterest user name 
               </label>
               <input value="<?php echo $gallery_user  ?>" name="gallery_user" id="gallery_user" required="required" type="text">
            </div>

			<div id="field-camp_type-container" class="field f_100" style="margin-top:10px" >
				<label for="field-camp_type">
					Gallery Type 
				</label>
				<select name="gallery_type" id="camp_type">
					<option  value="pins"  <?php  wp_pinterest_to_wp_opt_selected('pins',$gallery_type) ?> >Pins</option> 
					<option  value="boards"  <?php  wp_pinterest_to_wp_opt_selected('boards',$gallery_type) ?> >Boards</option>					 
					<option  value="board"  <?php  wp_pinterest_to_wp_opt_selected('board',$gallery_type) ?> >Specific Board</option>
				</select>
				
			</div>


			<div style="display: none;" id="field-camp_type-board-container" class="field f_100" style="margin-top:10px" >
				<label for="field-camp_type">
					Choose a board <a id="update_boards" href="<?php echo   site_url('/?wp_pinterest_to_wp=fetch_boards'); ?>">update boards</a> <img alt="" id="ajax-loadingimg" class="ajax-loading" src="images/wpspin_light.gif" style="float:right;margin:3px" >
				</label>
				<select name="gallery_board" id="camp_board">
					<?php 
						if(isset($gallery_boards[0][0])){
							$boards_ids=$gallery_boards[1];
							$boards_names=$gallery_boards[0];
							
							$s=0;
							foreach($boards_ids as $board_id){
								?>
								<option  value="<?php echo $board_id?>"  <?php  wp_pinterest_to_wp_opt_selected($board_id,$gallery_board) ?> ><?php echo $boards_names[$s]?></option>
								<?php 
								$s++;
							}
						}
					?> 
				</select>
				
			</div>			
			
          <div id="field5-container" class="field f_100  ">
               <label for="field5">
                    Maximum number of items 
               </label>
               <input value="<?php echo $gallery_max   ?>" max="100" min="0" name="gallery_max" id="field1zz" required="required" class="ttw-range range"
               type="range">
          </div>	


          <div id="field5zzz-container" class="field f_100  ">
               <label for="field5zzz">
                    Gallery Item Width 
               </label>
               <input value="<?php echo $gallery_itm_width   ?>" max="1000" min="50" name="gallery_itm_width" id="field5zzz"   required="required" class="ttw-range range"
               type="range">
          </div>	          


          <div id="field5zzzg-container" class="field f_100  ">
               <label for="field5zzzg">
                    Gallery Item Height 
               </label>
               <input value="<?php echo $gallery_itm_height   ?>" id="field5zzzg" max="1000" min="50" name="gallery_itm_height"    required="required" class="ttw-range range"
               type="range">
          </div>          
          
            <div id="field6-container" class="field f_100">
               <label for="field6">
                    Padding (px) 
               </label>
               <input value="<?php echo $gallery_padding ?>" name="gallery_padding" id="field698" required="required" type="range"  max="100" min="0" >
            </div>
            
	        <div id="field-wp_pinterest_to_wp-container" class="field f_100" >

	        <div class="option clearfix">
		         <input     name="wp_pinterest_to_wp_ops[]" id="field-wp_pinterest_to_wp-1" value="OPT_DESC" type="checkbox">     
		          <span class="option-title">
		 			 Show description of the item (in page/post)
		          </span>
  
		     </div>

	        <div class="option clearfix">
		         <input     name="wp_pinterest_to_wp_ops[]" id="field-wp_pinterest_to_wp-3" value="OPT_DESC_POP" type="checkbox">     
		          <span class="option-title">
		 			 Show description of the item (in pop-up)
		          </span>
  
		     </div>		     

	        <div class="option clearfix">
		         <input     name="wp_pinterest_to_wp_ops[]" id="field-wp_pinterest_to_wp-3" value="OPT_LINK_POP" type="checkbox">     
		          <span class="option-title">
		 			 Show Link of item ( in pop-up )
		          </span>
  
		     </div>			     
		     
		     <div class="option clearfix">
		       <input     name="wp_pinterest_to_wp_ops[]" id="field-wp_pinterest_to_wp-1" value="OPT_LINK" type="checkbox">     
		          <span class="option-title">
		 			 Link pins to pinterest directly (no popup)
		          </span>
		     </div>

		     <div class="option clearfix">
		       <input     name="wp_pinterest_to_wp_ops[]"   value="OPT_LINK_BLANK" type="checkbox">     
		          <span class="option-title">
		 			 open links in new page (target="blank")
		          </span>
		     </div>
		     
		     <div class="option clearfix">
		       <input     name="wp_pinterest_to_wp_ops[]" id="field-wp_pinterest_to_wp-2" value="OPT_COUNT" type="checkbox">     
		          <span class="option-title">
		 			 Show count of items (boards only)
		          </span>
		     </div>
		     <div class="option clearfix">
		       <input     name="wp_pinterest_to_wp_ops[]" value="OPT_GALLERY" type="checkbox">     
		          <span class="option-title">
		 			 Add Navigation (next,previous buttons) when opening a pin in lightbox
		          </span>
		     </div>		     	
			</div>    	 


			<div id="field6g-container" class="field f_100">
               <label for="field6g">
                    Link color 
               </label>
               <input value="<?php echo $gallery_color  ?>" class="color" name="gallery_color" id="field6g" required="required" type="text">
            </div>			
			
         	<div id="field61-container" class="field f_100">
               <label for="field6">
                    Background 
               </label><br>
		 
		         <?php
	
		         	// none image
		         	$i=0;
		         	echo '<div class="wp_pinterest_to_wp_bg" style="background:url( \' '.plugins_url('images/patterns/pattern'.$i.'.png', __FILE__ ).' \' )" ><input type="radio"  name="gallery_bg" value="'.$i.'"></div>';
		         
		         
			         for ($i=8;$i<31;$i++){
			         	echo '<div class="wp_pinterest_to_wp_bg" style="background:url( \' '.plugins_url('images/patterns/pattern'.$i.'.png', __FILE__ ).' \' )  repeat #FFFFFF" ><input type="radio" '.wp_pinterest_to_wp_opt_checked($i,$gallery_bg).'  name="gallery_bg" value="'.$i.'"></div>';
			         	
			         }
		         ?>
          
            </div>
          
         <div class="clear"></div>
         
         
         
	</div>
	
	 
	
		<script type="text/javascript">

	    var $vals = '<?php  echo  implode('|',  $wp_pinterest_to_wp_ops) ?>';

	    $val_arr = $vals.split('|');
	    jQuery('input:checkbox').removeAttr('checked');
	    jQuery.each($val_arr, function (index, value) {
	        if (value != '') {
	            jQuery('input:checkbox[value="' + value + '"]').attr('checked', 'checked');
	        }
	    });

	    
	</script> 

	<?php

	 
}

//save meta values 
add_action( 'save_post', 'wp_pinterest_to_wp_save_meta_data' );

function wp_pinterest_to_wp_save_meta_data($post_id){
	 
	//check post type
	$post_type = get_post_type( $post_id );
	
	if($post_type != 'wp_pinterest_to_wp') return false;
	
	//update meta values
	@update_post_meta($post_id,'gallery_user',$_POST['gallery_user']);
	@update_post_meta($post_id,'gallery_type',$_POST['gallery_type']);
	@update_post_meta($post_id,'gallery_padding',$_POST['gallery_padding']);
	@update_post_meta($post_id,'gallery_max',$_POST['gallery_max']);
	@update_post_meta($post_id,'gallery_bg',$_POST['gallery_bg']);
	@update_post_meta($post_id,'gallery_itm_width',$_POST['gallery_itm_width']);
	@update_post_meta($post_id,'gallery_itm_height',$_POST['gallery_itm_height']);
	@update_post_meta($post_id,'wp_pinterest_to_wp_ops',$_POST['wp_pinterest_to_wp_ops']);
	@update_post_meta($post_id,'gallery_color',$_POST['gallery_color']);
	@update_post_meta($post_id,'gallery_board',$_POST['gallery_board']);
	@update_post_meta($post_id,'gallery_update',$_POST['gallery_update']);
	@update_post_meta($post_id,'gallery_unit',$_POST['gallery_unit']);
	@update_post_meta($post_id,'gallery_itms',$_POST['gallery_itms']);
}


//metabox scripts 
add_action( 'admin_print_scripts-post-new.php', 'wp_pinterest_to_wp_admin_script', 11 );
add_action( 'admin_print_scripts-post.php', 'wp_pinterest_to_wp_admin_script', 11 );

function wp_pinterest_to_wp_admin_script() {
	global $post_type;
	if( 'wp_pinterest_to_wp' == $post_type ){
		wp_enqueue_script('wp_pinterest_to_wp_js_jqtools',	plugins_url( '/js/jquery.tools.js' , __FILE__ )	);
		wp_enqueue_script('wp_pinterest_to_wp_js_main',	plugins_url( '/js/main.js' , __FILE__ )	);
		wp_enqueue_script('wp_pinterest_to_wp_js_uniform',	plugins_url( '/js/jquery.uniform.min.js' , __FILE__ )	);
		wp_enqueue_style( 'wp_pinterest_to_wp_css' , plugins_url('css/style.css', __FILE__));
		wp_enqueue_style( 'wp_pinterest_to_wp_css_uniform' , plugins_url('css/uniform.css', __FILE__));
		wp_enqueue_script('jscolor',plugins_url('js/jscolor/jscolor.js', __FILE__));
	}
}