<?php
/*
Plugin Name:Pinterest to Wordpress by ValvePress
Plugin URI: http://codecanyon.net/item/pinterest-to-wordpress-plugin-/5304915?ref=ValvePress
Description: View Pinterest Pins & boards in your wordpress 
Version: 1.0.23
Author: ValvePress 
Author URI: http://codecanyon.net/user/ValvePress/portfolio?ref=ValvePress
*/

/*  Copyright 2013-2016  Pinterest to Wordpress  (email : sweetheatmn@gmail.com) */

/*
 * custom post type
*/
require_once('wp_pinterest_post_type.php');

/*
 *  metabox 
 */
require_once('metabox.php');
require_once('metabox2.php');
require_once('metabox3.php');
require_once('metabox4.php');

/*
 * shortcode
 */
require_once('shortcodes.php');

/*
 *deandev widget
 */
require_once 'widget.php';

/*
 * styles and js on front end
 */
add_action( 'wp_enqueue_scripts', 'wp_pinterest_to_wp_add_my_stylesheet' );

 
function wp_pinterest_to_wp_add_my_stylesheet() {
	
	
	// Respects SSL, Style.css is relative to the current file
	wp_enqueue_script('jquery');
	
	wp_enqueue_style( 'wp_pinterest_to_wp-style',plugins_url('css/style-front.css', __FILE__) );	
	wp_enqueue_script('prettyphoto',plugins_url('js/jquery.prettyPhoto.js', __FILE__));
	wp_enqueue_style( 'prettyphoto',plugins_url('css/prettyPhoto.css', __FILE__) );
	wp_enqueue_script('wp_pinterest_to_wp_main_front_js',plugins_url('js/main-front.js', __FILE__));
	wp_enqueue_script('wp-pinterest-masonry',plugins_url('js/masonry.pkgd.min.js', __FILE__));
	
	
	
	
	/*
	
	*/
}


/**
 * custom request for fetch boards
 */
function wp_pinterest_to_wp_parse_request($wp) {

	// only process requests with "my-plugin=ajax-handler"
	if (array_key_exists('wp_pinterest_to_wp', $wp->query_vars)) {
			
		if($wp->query_vars['wp_pinterest_to_wp'] == 'fetch_boards'){

			require_once('ajax.php');
			exit;

		}
	}
}
add_action('parse_request', 'wp_pinterest_to_wp_parse_request');



function wp_pinterest_to_wp_query_vars($vars) {
	$vars[] = 'wp_pinterest_to_wp';
	return $vars;
}
add_filter('query_vars', 'wp_pinterest_to_wp_query_vars');

/*
 * data tables when plugin get activated
 * 
 */
require_once('tables.php');
register_activation_hook( __FILE__, 'wp_pinterest_to_wp_create_table_all' );


//curl exists check
require_once 'p_notice.php';
