<?php
add_action( 'init', 'pinterest_to_wordpress_create_post_type' );
function pinterest_to_wordpress_create_post_type() {
	
	
	register_post_type( 'wp_pinterest_to_wp',
		array(
				'labels' => array(
				'name' => _x('Pinterest Galleries', 'post type general name'),
				'singular_name' => _x('Pinterest Gallery', 'post type singular name'),
			    'add_new' => _x('New Gallery', 'gallery'),
			    'add_new_item' => __("Add New Gallery "),
			    'edit_item' => __("Edit Gallery "),
			    'new_item' => __("New Gallery "),
			    'view_item' => __("View Gallery "),
			    'search_items' => __("Search Gallery "),
			    'not_found' =>  __('No galleries found'),
			    'not_found_in_trash' => __('No galleries found in Trash'),
			    'parent_item_colon' => '',
				'menu_name' => 'Galleries',
				'all_items' => 'Galleries'
						
			 ),
			
			
			'publicly_queryable' => false,
		    'show_ui' => true,
		    'query_var' => true,
		    'rewrite' => true,
		    'hierarchical' => false,
		    'menu_position' =>55555655555,
		    'capability_type' => 'post',
		    'supports' => array('title' ),
		    'menu_icon' => plugins_url('images/Pinterest-icon.png', __FILE__) ,
			 'label' => 'label ',
				
    )
    );
}

 
/*
 * custom columns
 */
add_action('manage_posts_custom_column', 'pinterest_to_wordpress_custom_columns');
add_filter('manage_edit-wp_pinterest_to_wp_columns', 'pinterest_to_wordpress_add_new_gallery_columns');
 
function pinterest_to_wordpress_add_new_gallery_columns( $columns ){
    $columns = array(
        'cb'                =>        '<input type="checkbox">',
        'title'                =>        'Gallery Title',
        'shortcode'            =>        'Short Code',
        'type'            =>        'Gallery type (boards/pins)',
        'username'                =>        'Pinterest User',
    	'number'                =>        'Number of Items',
    	'bg'                =>        'Background',
        
    );
    return $columns;
}
 
function pinterest_to_wordpress_custom_columns( $column ){
    global $post;
    
    switch ($column) {
        case 'pinterest_to_wordpress_post_thumb' : echo the_post_thumbnail(array(120,120)); break;
        case 'description' : the_excerpt(); break;
        case 'shortcode' : echo '[pinterest_gallery id="'.$post->ID.'"]'; break;
        case 'type' : echo get_post_meta($post->ID,'gallery_type',1);; break;
        case 'username' : echo get_post_meta($post->ID,'gallery_user',1);; break;
        case 'number' : echo get_post_meta($post->ID,'gallery_max',1);; break;
        case 'bg' : echo   '<div class="wp_pinterest_to_wp_bg" style="height:30px;width:60px;background:url( \' '.plugins_url('images/patterns/pattern'.get_post_meta($post->ID,'gallery_bg',1).'.png', __FILE__ ).' \' )" ></div>';
    }
}
